<?php
if ( ! class_exists( 'WC_Abstract_Privacy' ) ) {
	return;
}

class WC_Gateway_SnapNPay_Privacy extends WC_Abstract_Privacy {
	public function __construct() {
		parent::__construct( __( 'SnapNPay', 'woocommerce-gateway-snapnpay' ) );

		$this->add_exporter( 'woocommerce-gateway-snapnpay-order-data', __( 'WooCommerce SnapNPay Order Data', 'woocommerce-gateway-snapnpay' ), array( $this, 'order_data_exporter' ) );

		$this->add_eraser( 'woocommerce-gateway-snapnpay-order-data', __( 'WooCommerce SnapNPay Data', 'woocommerce-gateway-snapnpay' ), array( $this, 'order_data_eraser' ) );
	}

	protected function get_snapnpay_orders( $email_address, $page ) {
		$user = get_user_by( 'email', $email_address ); // Check if user has an ID in the DB to load stored personal data.

		$order_query    = array(
			'payment_method' => 'snapnpay',
			'limit'          => 10,
			'page'           => $page,
		);

		if ( $user instanceof WP_User ) {
			$order_query['customer_id'] = (int) $user->ID;
		} else {
			$order_query['billing_email'] = $email_address;
		}

		return wc_get_orders( $order_query );
	}

	public function get_privacy_message() {
		// FIXME
		return wpautop( sprintf( __( 'By using this extension, you may be storing personal data or sharing data with an external service. <a href="%s" target="_blank">Learn more about how this works, including what you may want to include in your privacy policy.</a>', 'woocommerce-gateway-snapnpay' ), 'https://docs.woocommerce.com/document/privacy-payments/#woocommerce-gateway-snapnpay' ) );
	}

	public function order_data_exporter( $email_address, $page = 1 ) {
		$done           = false;
		$data_to_export = array();

		$orders = $this->get_snapnpay_orders( $email_address, (int) $page );

		$done = true;
		if (count($orders) > 0) {
			foreach ($orders as $order) {
				$data_to_export[] = array(
					'group_id'    => 'woocommerce_orders',
					'group_label' => __( 'Orders', 'woocommerce-gateway-snapnpay' ),
					'item_id'     => 'order-' . $order->get_id(),
					'data'        => array(
						array(
							'name'  => __( 'SnapNPay token', 'woocommerce-gateway-snapnpay' ),
							'value' => get_post_meta( $order->get_id(), '_snapnpay_pre_order_token', true ),
						),
					),
				);
			}

			$done = count($orders) < 10;
		}

		return array(
			'data' => $data_to_export,
			'done' => $done,
		);
	}

	public function order_data_eraser($email_address, $page) {
		$orders = $this->get_snapnpay_orders($email_address, (int) $page);

		$items_removed  = false;
		$items_retained = false;
		$messages       = array();

		foreach ((array) $orders as $order) {
			$order = wc_get_order($order->get_id());

			list($removed, $retained, $msgs) = $this->maybe_handle_order($order);
			$items_removed  |= $removed;
			$items_retained |= $retained;
			$messages        = array_merge($messages, $msgs);
		}

		$done = count($orders) < 10;

		return array(
			'items_removed'  => $items_removed,
			'items_retained' => $items_retained,
			'messages'       => $messages,
			'done'           => $done,
		);
	}

	protected function maybe_handle_order( $order ) {
		$order_id      = $order->get_id();
		$snapnpay_token = get_post_meta( $order_id, '_snapnpay_pre_order_token', true );

		if ( empty( $snapnpay_token ) ) {
			return array( false, false, array() );
		}

		delete_post_meta( $order_id, '_snapnpay_pre_order_token' );

		return array( true, false, array( __( 'SnapNPay Order Data Erased.', 'woocommerce-gateway-snapnpay' ) ) );
	}
}

new WC_Gateway_SnapNPay_Privacy();
