<?php
/**
 * Plugin Name: WooCommerce Gateway for SnapNPay
 * Plugin URI: https://snapnpay.my/
 * Description: Receive payments using SnapNPay
 * Author: SnapNPay
 * Author URI: https://snapnpay.my/
 * Version: 0.10.1
 * Requires at least: 5.1
 * Tested up to: 5.3
 * WC tested up to: 3.8
 * WC requires at least: 2.6
 *
 */
defined( 'ABSPATH' ) || exit;

/**
 * Initialize the gateway.
 * @since 0.9.0
 */
function woocommerce_snapnpay_init() {
	if ( ! class_exists( 'WC_Payment_Gateway' ) ) {
		return;
	}

	define( 'WC_GATEWAY_SNAPNPAY_VERSION', '0.10.1' );

	require_once( plugin_basename( 'includes/class-wc-gateway-snapnpay.php' ) );
	require_once( plugin_basename( 'includes/class-wc-gateway-snapnpay-privacy.php' ) );
	load_plugin_textdomain( 'woocommerce-gateway-snapnpay', false, trailingslashit( dirname( plugin_basename( __FILE__ ) ) ) );
	add_filter( 'woocommerce_payment_gateways', 'woocommerce_snapnpay_add_gateway' );
}
add_action( 'plugins_loaded', 'woocommerce_snapnpay_init', 0 );

function woocommerce_snapnpay_plugin_links( $links ) {
	$settings_url = add_query_arg(
		array(
			'page' => 'wc-settings',
			'tab' => 'checkout',
			'section' => 'wc_gateway_snapnpay',
		),
		admin_url( 'admin.php' )
	);

	$plugin_links = array(
		'<a href="' . esc_url( $settings_url ) . '">' . __( 'Settings', 'woocommerce-gateway-snapnpay' ) . '</a>',
		'<a href="https://www.woocommerce.com/my-account/tickets/">' . __( 'Support', 'woocommerce-gateway-snapnpay' ) . '</a>',
		// '<a href="https://docs.woocommerce.com/document/snapnpay-payment-gateway/">' . __( 'Docs', 'woocommerce-gateway-snapnpay' ) . '</a>',
	);

	return array_merge( $plugin_links, $links );
}
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'woocommerce_snapnpay_plugin_links' );


/**
 * Add the gateway to WooCommerce
 * @since 0.9.0
 */
function woocommerce_snapnpay_add_gateway( $methods ) {
	$methods[] = 'WC_Gateway_SnapNPay';
	return $methods;
}
