<?php

// Use:
//   php -S localhost:8000
// To quickly test

// Requires curl
include 'SnapNPay.php';

// There are two ways to authenticate against SnapNPay/Tulus:
// 1. Token
// 2. API Key Signature
// The API Key based approach is the current preferred way, as it requires one less
// API call, and allows for 

// They are two classes of API:
// Reporting
// Payment/FrontEnd 

$ENDPOINT = "https://prod.snapnpay.co/payments/api";
$ENDPOINT = "https://snapnpay.my/v2/checkout";
$CHECKOUT_ENDPOINT = "https://snapnpay.my/v2/checkout";
// $ENDPOINT = "http://localhost:9998/v2/checkout";

$agency = "kasihgold";
$api_key = "DACA31D4-869A-4323-9455-E4F533EB08DC";


$snp = new SnapNPay\SnapNPay($agency, $api_key);

$fpx_refno = $_POST['refno'] ?? '';

$items_per_page = 20;
if (isset($_POST['items'])) {
    $snp->SetItemsPerPage($_POST['items']);
    $items_per_page = $_POST['items'];
}

$output = "";
if ($_SERVER['REQUEST_METHOD'] == "POST" && ($_POST['gettoken'] ?? "") == "") {
    if ($fpx_refno != "") {
        $output = $snp->GetFpxRequestReport($fpx_refno);
    } else {
        if ($_POST['email'] ?? "" != "") {
            $output = $snp->GetTransactionHistory($_POST['email']);
        }
        // $output = $snp->GetPaymentReport();
    }
} else {

}

// ----------------------------------------------------------------------------------------------------------------
function isSecure() {
    return
      (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off')
      || $_SERVER['SERVER_PORT'] == 443;
}
$scheme = isSecure() ? 'https' : 'http';
$returnUrl = sprintf("%s://%s", $scheme, $_SERVER['HTTP_HOST']);
$returnUrl .= "?just=1&a=test";

// The returnUrl here is for getting the result of the transaction.
// There are two ways for this to happen: "indirect" and "direct"
// In this example, it's processed in the
//
// "Indirect" is a request POSTed by the client's browser with after
// the completion of the request.
// "Direct" is a request POSTed by SnapNPay's server after the completion
// of the request.

// This parameter can be set during "dev" mode, but "prod" mode may
// impose more restrictions in terms of which addresses are valid.

// The data returned in $_POST looks like this:
//
/*
    Array
    (
        [status] => success
        [orderNo] => LP-0000179356e010000
        [refNo] => test5dbfdd8d9db55
        [amount] => 1.00
        [fpxTxnId] => 1911041613340758
        [extraData] => 881225-08-1234
    )
*/

// ----------------------------------------------------------------------------------------------------------------
// Payment API Example
// This is vastly simplified. Use and adapt for your own class
// Unless otherwise stated, the types in the following fields are specified in string, and is up to 255 bytes ASCII
// Use of UTF-8 values in the following may result in undefined behaviours.
$order = array(
    'agency'    => 'snapnpay',          // Enter your agency code here.
    'refNo'     => uniqid("test"),      // Generate a unique ID, prefixed with "test", but append some "extraData"
    'amount'    => "1.00",              // Amount in Ringgit
    'email'     => "sdk@snapnpay.my",   // Email address of payer to receive payment receipt
    'returnUrl' => $returnUrl,          // callback url, change this to your form
);

// $extraData is extra, *optional* reference for helping the calling app, e.g. adding a MyKad reference.
// it can be anything alphanum, except "~"
$extraData = "881225-08-1234";
if ($extraData != "") {
    // We hitch on refNo to give this extradata
    $order['refNo'] = $order['refNo'] . "~" . $extraData;
}

// Default QR Code Generator for the SnapNPay App
// This is simplified structure of the QRCode generator. Use and adapt for your own class.
$qrcode = array(
    'agency'          => $order['agency'],
    'paymentCategory' => 'test',
    'refNo'           => uniqid("test"),
);
// Note the similarity of the qrcode structure with $order above, but:
// "email" is not used -- they will be filled in by the SnapNPay App
// "returnUrl" is optional

// There are two types of QRCode generation, secure ("signed/tamper resistant") and unsigned.
// You need to sign in (and get the secure token), to be able to generate the secured QR Code.
if (false) {
    // Example:
    $token = $snp->GetToken("myagency", "mypassword");
    for ($i = 0; $i < 10; $i++) {
        $qrcode['refNo'] = uniqid($i);
        $snp->GetSecureQRCodeUrl($qrcode); // Returns a URL that will return a PNG of the QR Code.
    }
}

// ----------------------------------------------------------------------------------------------------------------
// *Indirect* + *Direct* handling:
// Example of getting and processing the result from SnapNPay/FPX:
if (isset($_POST['status'])) {
    // This is a callback, ie, a return from processing the payment.
    $callback_status = $_POST;
} else {
    $callback_status = false;
}

?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta http-equiv="X-UA-Compatible" content="ie=edge" />
        <title>SnapNPay SDK</title>
        <script>
            function isValidEmail(email) {
                var regex = /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/;
                return email.match(regex);
            }
            function checkValidEmail(email) {
                if (!isValidEmail(email)) {
                    alert("Please enter a valid email");
                }
            }
        </script>
    </head>
    <body>
        <h1>SnapNPay/Tulus v2 API</h1>
<?php
if (sizeof($_POST) > 0 || sizeof($_GET) > 0) {
    print "<h3>Responses</h3>";
    print "<div style='border: 2px black solid'>";
    print "POST variables: <pre>";
    print_r($_POST);
    print "</pre><br />";
    print "GET variables: <pre>";
    print_r($_GET);
    print "</pre><br />";
    print "</div>";
}
?>
<?php
if (sizeof($_POST) > 0 && ($_POST['qrcode']??"") != "") {
    $qrcode['agency'] = $_POST['agency'] ?? "";
    $qrcode['paymentCategory'] = $_POST['paymentCategory'] ?? "";
    $qrcode['refno'] = $_POST['refno'] ?? "";
    $qrcode['amount'] = $_POST['amount'] ?? "";

    $extra_keys = $_POST['extra_keys'] ?? [];
    $extra_values = $_POST['extra_values'] ?? [];

    $extra_data = array();
    for ($i = 0; $i < count($extra_keys); $i++) {
        if ($extra_keys[$i] !== '') {
            $key = $extra_keys[$i];
            $value = $extra_values[$i];
            $extra_data[$key] = $value;
        }
    }

    if (count($extra_data) > 0) {
        $qrcode['extras'] = $extra_data;
    }

    $img = $snp->GetQRCodeUrl($qrcode);
    print "QR Code:<br />";
    print '<img src="'.$img.'"/>';
    print "<br />";

    $img = $snp->GetSecureQRCodeUrl($qrcode);
    print "Secure QR Code:<br />";
    print '<img src="'.$img.'"/>';
    print "<hr />";

}
?>
        <h3>Pay (Checkout):</h3>
        <!-- Payment Example -->
        Example order:
        <pre>order = <?php print_r($order); ?></pre>
        <form method="post" action="<?php print $CHECKOUT_ENDPOINT; ?>">
            Reference No:
            <input type="text" size=40 name="refNo" value="<?php echo htmlentities($order["refNo"]); ?>" /><span
                class="error"
                >*</span
            >
            <br /><br />
            Amount: <input type="text" size=40 name="amount" value="<?php echo htmlentities($order["amount"]??""); ?>" /><span
                class="error"
                >*</span
            >
            <br /><br />
            E-mail:
            <input type="text" size=40 name="email" value="<?php echo htmlentities($order["email"]??""); ?>" onchange="checkValidEmail(this.value)" /><span
                class="error"
                >*</span
            >
            <br /><br />
            Agency Code (to be hidden):
            <input type="text" size=40 name="agency" value="<?php echo htmlentities($order["agency"]??""); ?>" readonly="1" /><span
                class="error"
                >*</span
            >
            <br /><br />
            Return URL (to be hidden):
            <input
                type="text" size=40 name="returnUrl"
                value="<?php echo htmlentities($order["returnUrl"]??""); ?>"
                readonly
            /><span class="error">*</span> <br /><br />

            Signature: <input type="text" size="50" name="signature" readonly="1" value="foo "/>

            <br /><br />
            <input type="submit" name="submit" value="Submit" />
        </form>
        <!-- End payment Example -->


    </body>
</html>
