<?php
define('TOKEN', 'token');

session_start();

$token = isset($_SESSION[TOKEN]) ? $_SESSION[TOKEN] : '';
if ($token) {
    header('Location: ./index.php');
    exit();
}

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'POST') {
    $username = isset($_POST['username']) ? $_POST['username'] : '';
    $password = isset($_POST['password']) ? $_POST['password'] : '';

    $authtoken = $_POST['authtoken'] ?? '';

    include '../../Tulus.php';

    $snp = new Tulus\Tulus();

    if ($authtoken != "") {
      $_SESSION[TOKEN] = $authtoken;
      header('Location: ./');
    } else {
        try {
            $token = $snp->GetToken($username, $password);
            $_SESSION[TOKEN] = $authtoken;
            header('Location: ./');
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>SnapNPay Report - Login</title>
    <link
      rel="stylesheet"
      href="https://assets.tulus.my/bootstrap-4.5/css/bootstrap.min.css"
      
      crossorigin="anonymous"
    />
  </head>
  <body class="bg-light">
    <div class="container mt-5">
      <h1 class="text-center">Login</h1>
      <div class="row mt-3">
        <div class="col-6 bg-white mx-auto border rounded-sm px-4 py-3">
          <form action="" method="post">
            <div class="form-group">
              <label for="authtoken">Auth Token</label>
              <input
                type="password"
                class="form-control"
                name="authtoken"
                id="authtoken"
              />
            </div>
            <button type="submit" class="btn btn-primary">Login</button>
          </form>
        </div>
      </div>
      <hr />
      <h1 class="text-center">Login (Legacy)</h1>

      <div class="row mt-3">
        <div class="col-6 bg-white mx-auto border rounded-sm px-4 py-3">
          <form action="" method="post">
            <div class="form-group">
              <label for="username">Username</label>
              <input
                type="text"
                class="form-control"
                name="username"
                id="username"
              />
            </div>

            <div class="form-group">
              <label for="password">Password</label>
              <input
                type="password"
                class="form-control"
                name="password"
                id="password"
              />
            </div>
            <button type="submit" class="btn btn-primary">Login</button>
          </form>

        </div>
      </div>
    </div>
  </body>
</html>
