<?php

// Example call back from payment.

// This will be invoked and called from two different places
// 1. The user (aka "indirect"), which is useful to get feedback and displaying receipts to the user
//    directly.
// 2. The server (aka "direct"), which is useful to update your backend of payment statuses in "Real Time",
//    if or when the user fails to use the indirect above, and as alternative or in addition to "settlement"
//    operations via the Merchant Report API/SDK or the Merchant Dashboard.

// For historical reasons, we support both from the same returnUrl

if (isset($_REQUEST["signature"])) {
    // Direct response callbacks/webhooks from the Tulus server has additional "signaure" value
    $orderNo = $_REQUEST["orderNo"] ?? "";

    // Save the result as a JSON to a log file.
    $handle = fopen("/tmp/log/requestlog.txt", "a+");

    $fpx = isset($_REQUEST["fpx"]) ? json_decode($_REQUEST["fpx"]) : array();

    if ($handle != false) {
        fwrite($handle, json_encode($_REQUEST)."\n");
        fwrite($handle, json_encode($fpx) ."\n");
        fclose($handle);    
    } else {
        print "Error writing ";
        print json_encode($_REQUEST);
    }

    // Additionally, add to a JSON file for easy reading.
    $archive = file_get_contents("/tmp/log/requestarchive.json");
    $archive = json_decode($archive, true);
    if ($archive == null) {
        $archive = array();
    }
    $data = array(
        'time' => time(),
        'orderNo' => $orderNo,
        'fpx' => $fpx,
        'request' => $_REQUEST,
        'GET' => $_GET,
        'POST' => $_POST,
        'server' => $_SERVER,
    );
    $archive[] = $data;

    // Trim data to last 1000
    $archive = array_slice($archive, -1000);
    file_put_contents("/tmp/log/requestarchive.json", json_encode($archive, JSON_PRETTY_PRINT));
} else {
    // Indirect.
    $amount = $_REQUEST["amount"] ?? "";
    $refNo = $_REQUEST["refNo"] ?? "";
    $orderNo = $_REQUEST["orderNo"] ?? "";
    $fpxTxnId = $_REQUEST["fpxTxnId"] ?? "";
    $extraData = $_REQUEST["extraData"] ?? "";
    $status = $_REQUEST["status"] ?? "failed";
    $fpx = isset($_REQUEST["fpx"]) ? json_decode($_REQUEST["fpx"], true) : array();
    $fpx_seller_order_no = $fpx["fpx_seller_order_no"] ?? "";

    if ($status == "success") {
        print "<html><body>
        Thank you for your payment of RM ".$amount." ".$fpx_seller_order_no."
        </body></html>";
    } else if ($status == "pending") {
        print "<html><body>
        Your payment of RM ".$amount." is pending approval. ".$fpx_seller_order_no."
        </body></html>";
    } else {
        print "<html><body>
        We're sorry your payment of RM ".$amount." did not succeed. ".$fpx_seller_order_no."
        </body></html>";
    }
    print "<!--";
    print json_encode($fpx);
    print_r($_REQUEST);
    print "-->";
}