<?php

date_default_timezone_set('Asia/Kuala_Lumpur');

$archive = file_get_contents("/tmp/log/requestarchive.json");
if (empty($archive)){
    $archive = file_get_contents("requestarchive.json");
}
$archive = json_decode($archive, true);

if (sizeof($archive)==1) {
    array_push($archive, $archive[0]);
}

$verbose = false;
if (isset($_REQUEST["verbose"])) {
    $verbose = true;
}

if (false) {
    print("<pre>");
    print_r($archive);
    print("</pre>");
} ?><!doctype html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

  <title>Tulus Developer - Callback Log</title>
  <link rel="stylesheet" href="https://assets.tulus.my/bootstrap-4.5/css/bootstrap.min.css"
    crossorigin="anonymous">

  <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"
    integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj"
    crossorigin="anonymous"></script>
  <script src="https://assets.tulus.my/popperjs/popper.js" ></script>
  <script src="https://assets.tulus.my/bootstrap-4.5/js/bootstrap.min.js"
    
    crossorigin="anonymous"></script>
  <link rel="icon" href="https://assets.tulus.my/tulus-icon.png" sizes="32x32" />
</head>

<body>
    <div class="d-flex flex-column flex-md-row align-items-center p-3 px-md-4 mb-3 bg-white border-bottom box-shadow">
    <h5 class="my-0 mr-md-auto font-weight-normal">Tulus Developer Utilities</h5>
    <!-- Work In Progress -->
  </div>

    <div class="container">

    <h2 class="display-5">Callback Log</h2>

    <table class="table">
        <thead>
            <tr>
                <th>Time of Callback</th>
                <th>Agency/Seller Order No</th>
                <th>Payment Method</th>
                <th>Amount</th>
                <th>Status</th>
                <th>From Server IP</th>
<?php if ($verbose): ?><th>Raw</th><?php endif; ?>
            </tr>
        </thead>

        <tdata>
            <?php foreach ($archive as $k => $v) { ?>
            <tr>
                <td><?php print date('j M o h:i:s A', $v['time']); ?></td>
                <td>
                    <?php
                        $agency = $v['fpx']['agency'] ?? "";
                        print $agency."<br />";
                        $fpx_seller_order_no = $v['fpx']['fpx_seller_order_no'] ?? "";
                        print $fpx_seller_order_no;
                    ?>
                </td>
                <td>
                    <?php
                        $payment_method = $v['fpx']['payment_method'] ?? "";
                        print($payment_method);
                    ?>
                </td>
                <td style="text-align: right">
                    <?php
                        $amount = $v['fpx']['fpx_txn_amount'] ?? $v['amount'] ?? "";
                        print($amount);
                    ?>
                </td>
                <td>
                <?php
                    $status = $v['request']['status'] ?? "";
                    print($status);
                ?>
                </td>
                <td>
                <?php
                    $server_ip = $v['server']['HTTP_CF_CONNECTING_IP'] ?? "";
                    if (!empty($server_ip)) {
                        $server_ip .= " via ".$v['server']['REMOTE_ADDR'] ?? "";
                    }
                    print("<code>".$server_ip."</code>");
                ?>
                </td>
                <?php if ($verbose): ?>
                <td>
                    <pre><?php print json_encode($v, JSON_PRETTY_PRINT); ?></pre>
                </td>
                <?php endif; ?>
            </tr>
            <?php } ?>
        </tdata>


    </table>
    </div>
</body>

</html>